/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.crypto;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.talend.daikon.crypto.CipherSource;
import org.talend.daikon.crypto.KeySource;

public class Encryption {
    private static final Logger LOGGER = Logger.getLogger(Encryption.class.getCanonicalName());
    private final KeySource source;
    private final CipherSource cipherSource;

    public Encryption(KeySource source, CipherSource cipherSource) {
        this.source = source;
        this.cipherSource = cipherSource;
    }

    private static UserInfo extractCredentials(URI uri) {
        String[] parts;
        String rawUserInfo = uri.getUserInfo();
        if (StringUtils.isNotBlank((CharSequence)rawUserInfo) && (parts = rawUserInfo.split(":")).length > 1) {
            String part0 = parts[0];
            return new UserInfo(part0, rawUserInfo.substring(part0.length() + 1));
        }
        return null;
    }

    private static URI setCredentials(URI uri, UserInfo userInfo) throws URISyntaxException {
        return new URIBuilder(uri).setUserInfo(userInfo.userName, userInfo.password).build();
    }

    public String encrypt(String src) throws Exception {
        return this.cipherSource.encrypt(this.source, src);
    }

    public String decrypt(String src) throws Exception {
        return this.cipherSource.decrypt(this.source, src);
    }

    public String decrypt(String name, String src) {
        try {
            return this.decrypt(src);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "could not decrypt {0}, return it as it is", name);
            return src;
        }
    }

    public String decryptUriPassword(String rawUri) {
        URI uri;
        try {
            uri = new URI(rawUri);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.INFO, "Invalid URI " + rawUri, e);
            return rawUri;
        }
        UserInfo userInfo = Encryption.extractCredentials(uri);
        if (userInfo != null && userInfo.password != null) {
            try {
                userInfo.password = this.decrypt(userInfo.password);
                return Encryption.setCredentials(uri, userInfo).toString();
            }
            catch (Exception e) {
                LOGGER.info("Could not decrypt URI password.");
                return rawUri;
            }
        }
        return rawUri;
    }

    public String encryptUriPassword(String rawUri) throws Exception {
        URI uri = new URI(rawUri);
        UserInfo userInfo = Encryption.extractCredentials(uri);
        if (userInfo != null && userInfo.password != null) {
            userInfo.password = this.encrypt(userInfo.password);
            return Encryption.setCredentials(uri, userInfo).toString();
        }
        return rawUri;
    }

    private static class UserInfo {
        String userName;
        String password;

        public UserInfo(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }
    }
}

