/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.crypto;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.talend.daikon.crypto.Encryption;

public class PropertiesEncryption {
    private static final Logger LOGGER = Logger.getLogger(PropertiesEncryption.class.getCanonicalName());
    private final Encryption encryption;

    public PropertiesEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public void encryptAndSave(String input, Set<String> mustBeEncrypted) {
        this.modifyAndSave(input, mustBeEncrypted, this::encryptIfNot);
    }

    public void decryptAndSave(String input, Set<String> mustBeDecrypted) {
        this.modifyAndSave(input, mustBeDecrypted, this::decryptIfNot);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadAndDecrypt(String input, Set<String> mustBeDecrypted) {
        Path inputFilePath = Paths.get(input, new String[0]);
        if (Files.exists(inputFilePath, new LinkOption[0]) && Files.isRegularFile(inputFilePath, new LinkOption[0]) && Files.isReadable(inputFilePath)) {
            try (BufferedReader inputReader = Files.newBufferedReader(inputFilePath);){
                Properties result = new Properties();
                result.load(inputReader);
                for (String key : mustBeDecrypted) {
                    result.computeIfPresent(key, (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> this.castAndDecryptIfNot(v)));
                }
                Properties properties = result;
                return properties;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to load input " + input, e);
                throw new RuntimeException(e);
            }
        }
        LOGGER.log(Level.SEVERE, "Input file does not exist " + input);
        throw new RuntimeException(new FileNotFoundException(input));
    }

    private void modifyAndSave(String input, Set<String> mustBeModified, Function<String, String> function) {
        Path inputFilePath = Paths.get(input, new String[0]);
        if (Files.exists(inputFilePath, new LinkOption[0]) && Files.isRegularFile(inputFilePath, new LinkOption[0]) && Files.isReadable(inputFilePath)) {
            try {
                Parameters params = new Parameters();
                FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.fileBased().setFile(inputFilePath.toFile())});
                PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
                for (String key : mustBeModified) {
                    String value = config.getString(key);
                    if (value == null) continue;
                    config.setProperty(key, (Object)function.apply(config.getString(key)));
                }
                builder.save();
            }
            catch (ConfigurationException e) {
                LOGGER.log(Level.SEVERE, "unable to read " + input, e);
            }
        } else {
            LOGGER.log(Level.FINE, "No readable file at " + input);
        }
    }

    private String encryptIfNot(String input) {
        try {
            this.encryption.decrypt(input);
            return input;
        }
        catch (Exception e) {
            try {
                return this.encryption.encrypt(input);
            }
            catch (Exception e1) {
                LOGGER.log(Level.FINE, "Error encrypting value.", e1);
                return "";
            }
        }
    }

    private String decryptIfNot(String input) {
        try {
            return this.encryption.decrypt(input);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Trying to decrypt a non encrypted property.", e);
            return input;
        }
    }

    private Object castAndDecryptIfNot(Object input) {
        return this.decryptIfNot(String.valueOf(input));
    }
}

